unit Common1;

interface

uses
  Windows, SysUtils, MMSystem;

// ==========================================================================
//    
// ==========================================================================
// --------------------------------------------------------------------------
//      (. unit SensorGroup01)
// (   !)
const REC1MaxIndx = 11;

//       
// ( !)
type TREC1 = packed record
     Id    : string[8];
     Arr   : array[0..REC1MaxIndx] of extended;
end;
// --------------------------------------------------------------------------
//      (. unit SensorGroup02)
// (   !)
const REC2MaxIndx = 11;

//        'GET:REC2'
// ( !)
type TREC2 = packed record
     Id    : string[8];
     Arr   : array[0..REC2MaxIndx] of extended;
end;
// --------------------------------------------------------------------------
//        'GET:REC3'
// ( !)
type TREC3 = packed record
     Id    : string[8];
     Pith  : extended;
     Roll  : extended;
end;

// --------------------------------------------------------------------------
//      (. unit SensorGroup04)
// (   !)
const REC4MaxIndx = 11;

//        'GET:REC2'
// ( !)
type TREC4 = packed record
     Id    : string[8];
     Arr   : array[0..REC4MaxIndx] of extended;
end;

// =========================================================================
//       
// =========================================================================
//      ( 1 msec)
//    unit MMSystem.pas
type TTimeStampsMM = record
  MMErr  : word;             //      
  BTime  : LongInt;          //    msec
  ETime  : LongInt;          //    msec
end;
// -------------------------------------------------------------------------

//    
function StartMMTimeStamp (var RqStamp  : TTimeStampsMM) : string;

//       
function StopMMTimeStamp (var RqStamp  : TTimeStampsMM) : string;

// ==========================================================================
//  
// ==========================================================================
// --------------------------------------------------------------------------
//   
var ApplicationDirectory : string;


// ==========================================================================
//      
// ==========================================================================

var  REC1 : TREC1;   //    'REC1'
     REC2 : TREC2;   //    'REC2'
     REC3 : TREC3;   //    'REC3'
     REC4 : TREC4;   //    'REC4'

// ==========================================================================
implementation
// ==========================================================================

// =========================================================================
//       
// =========================================================================
// 02.01.2017
//    
function StartMMTimeStamp (var RqStamp  : TTimeStampsMM) : string;
begin
   Result := '';
   try
       RqStamp.BTime := timeGetTime;
       RqStamp.MMErr := 0;
   except
       RqStamp.MMErr := 1;          //   
       Result := '.';
   end;
end;
// -------------------------------------------------------------------------
// 02.01.2017
//       
function StopMMTimeStamp (var RqStamp  : TTimeStampsMM) : string;
begin
   if RqStamp.MMErr = 0
   then begin
      with RqStamp
      do begin
          try
            ETime := timeGetTime;
            if (ETime - BTime) >= 0
            then Result := IntToStr(ETime - BTime);
          except
            MMErr := 1;
            Result := '.';
          end;
      end;
   end;
end;

// ==========================================================================
// 
// ==========================================================================
end.
